% ALPHA ENGINE DEFINITION
% Generated 29-Jul-2020 11:47:29

% SUGGESTED CITATION:
% 2018 Toyota 2.5L A25A-FKS Engine Tier 2 Fuel - ALPHA Map Package. Version 2020-07. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2020.


% Constructor
engine = class_REVS_engine();
engine.name =  '2018 Toyota 2.5L A25A-FKS Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.487; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 
engine.bore_mm =  87.5; 
engine.stroke_mm =  103.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     103.12505234162977	;     105.05060883873348	;     121.15898176234263	;     157.00483285440416	;     211.47718214102289	;     265.59208773845728	;     313.74614017119956	;     422.72974799570221	;     470.72348049373937	;     523.59877559829886	;     691.15038378975441	;     725.70790297924214	;     760.26542216872997		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     114.50000000000000	;     162.53695652173909	;     179.76779661016951	;     198.24725274725276	;     214.35416666666671	;     225.47875647668405	;     220.25164835164833	;     235.16847826086948	;     236.85520833333331	;     249.47051199999999	;     219.02551316964789	;     187.73615414541248	;    0.00000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     105.03391438501875	;     373.95424553230504	;     470.50585975263135	;     603.18578948924028	;     760.26542216872997		]; 
engine.closed_throttle_torque_Nm = [	    -15.948686146731134	;    -22.000000000000000	;    -31.699999999999999	;    -38.600000000000001	;    -50.700000000000003	;    -59.749821315955444		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     40.540642121420589	;     81.081284242841178	;     108.90640491021287	;     138.86135520377456	;     156.88166247576345	;     181.05631740574222	;     211.24466377978447	;     265.47141566072946	;     313.66095091606940	;     373.97057705343684	;     422.27976929908095	;     470.51933431633228	;     518.81071920865065	;     566.98449891520715	;     603.19949327398876	;     681.73245772135942	;     760.26542216872997		]; 
engine.fuel_map_torque_Nm = [	    -62.737312381753220	;    -47.516666666666666	;    -37.300833333333330	;    -27.085000000000001	;    -12.425833333333333	;     2.2333333333333334	;     10.512499999999999	;     17.696874999999999	;     32.564285714285717	;     45.700000000000003	;     55.605000000000004	;     72.757894736842104	;     87.066666666666663	;     91.799999999999997	;     99.400000000000006	;     113.13999999999999	;     130.45999999999998	;     140.84999999999999	;     151.47248622589532	;     161.29379940711465	;     172.35006675567422	;     189.16123665966307	;     204.97210407128443	;     215.87274746501913	;     230.17722599761458	;     246.06063179880729	;     261.94403760000000		]; 
engine.fuel_map_gps = [
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.012623679004597602	  0.092874172983330075	   0.25827811073192158	   0.42143094427348848	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.036472128845502355	   0.16458945144503140	   0.29546175117465229	   0.39289370247255745	   0.59807455030884260	   0.80074832313257172	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	 0.0035959262960722415	  0.042155020264574843	   0.10112754434380657	   0.17670796249244863	   0.28827111353147644	   0.42948823356174803	   0.58027647068142429	   0.69417883436704642	   0.93890489022129020	    1.1811677103263332	;
   0.00000000000000000	  0.025958680890929169	  0.066882129989041320	  0.091666015839545936	   0.11544214320613216	   0.12869106714271827	   0.14603681906634361	   0.16900816971414387	   0.22235113221461772	   0.28971447543841694	   0.40025231928587440	   0.51743529524934628	   0.65988167719300572	   0.82317422183812961	   0.99867490286258909	    1.1338202122469760	    1.4328555863504722	    1.7308509319306855	;
  0.011419778982315212	  0.080004717016239998	   0.15168312795826300	   0.19895450525419620	   0.23936617519783843	   0.26231462712324077	   0.29454431600152137	   0.33906995607230511	   0.43071882332553918	   0.53359860244755253	   0.69731433690217359	   0.85441718731221805	    1.0309742629042109	    1.2244663748917921	    1.4294832850857526	    1.5875067587343819	    1.9387433698626448	    2.2893807798445289	;
  0.025823853201822296	   0.10298961244364190	   0.18007132820074628	   0.23164787774066531	   0.28670873419781628	   0.32159878922907692	   0.36888659988111183	   0.42946342084454947	   0.54494179259470843	   0.66946252600525047	   0.86354957571160140	    1.0419325371444432	    1.2373779127762565	    1.4492203860228470	    1.6747340058931437	    1.8484746323344561	    2.2291428152169814	    2.6092128656247606	;
  0.037332573832098474	   0.12274216591870225	   0.20614121167202581	   0.26332996890506039	   0.33093232902018699	   0.37394559035221481	   0.43248893234190067	   0.50453043464686564	   0.64298697819234740	   0.78712152964606685	    1.0069363640480544	    1.2035193130087813	    1.4148171163354217	    1.6425827506273447	    1.8876312142974907	    2.0765249767042127	    2.4827588815775248	    2.8887904348517988	;
  0.055746993686289867	   0.15869812410133957	   0.26149363886146587	   0.33289198901206213	   0.42070743583338072	   0.47742126299437815	   0.55561110090110866	   0.65393392922691873	   0.84490224251477331	    1.0266991674409880	    1.2968765383766323	    1.5332479083626276	    1.7738811950420394	    2.0349223455136696	    2.3263366048403271	    2.5507782043226217	    3.0129198356036291	    3.4770994968936342	;
  0.066959140738101983	   0.19197241559094994	   0.31685860018803008	   0.40331100628780558	   0.50726134050653049	   0.57411455349625018	   0.66672406870936030	   0.78639202281499687	    1.0113348476409829	    1.2250974718771506	    1.5425318366036096	    1.8165513255880441	    2.0930168229291879	    2.3859064373031718	    2.7117760145884366	    2.9582955927411971	    3.4858661488677938	    4.0142706767263565	;
  0.074241171277086279	   0.21879913177330637	   0.36421396097529196	   0.46487130748444205	   0.58292855718699355	   0.65473027721244803	   0.75423231798537937	   0.88863608091856472	    1.1384494068640247	    1.3757540568681266	    1.7255959354638386	    2.0309730384151825	    2.3395762192107874	    2.6661759093265212	    3.0130342683460851	    3.2711045173973301	    3.8484387577523287	    4.4295736698175210	;
  0.086911468722065899	   0.26667405760947727	   0.44625107423654276	   0.56673392055802774	   0.70639849511975095	   0.79269299277881722	   0.91076152460804871	    1.0637596900324913	    1.3699511875161796	    1.6396250289146161	    2.0411441073390222	    2.4177587241922205	    2.7651821962671215	    3.1485481932375809	    3.5489328450060782	    3.8343292711040169	    4.4997275092293938	    5.1755696622830110	;
  0.098892291510938229	   0.30272425392744268	   0.50281458365227072	   0.64037236677594944	   0.79751152690003224	   0.89747679724133644	    1.0365906029910137	    1.2164345023729508	    1.5635718466929056	    1.8711075897887459	    2.3161588650871585	    2.7148124532235758	    3.1143504013903156	    3.5380919672500535	    3.9844072089688449	    4.3242714505026152	    5.0783304731603511	    5.8312969930139937	;
   0.10325529950406534	   0.31627909147688427	   0.52622635709329935	   0.66860410072501930	   0.82908921485451181	   0.93223025011340410	    1.0761544003033530	    1.2632806401391696	    1.6222031565924577	    1.9461101984425637	    2.4053653386903076	    2.8124666594803416	    3.2284877798948859	    3.6644848379883377	    4.1265006324279323	    4.4885545411997079	    5.2725348430562917	    6.0522140691349380	;
   0.11099809631206753	   0.33872285073327491	   0.56666689813110349	   0.71488524705712320	   0.88216189925558741	   0.98947452042381190	    1.1397088884598479	    1.3370033744230985	    1.7166527048755418	    2.0640267668239813	    2.5465369616372318	    2.9706302139920533	    3.4116030345336097	    3.8664514354182864	    4.3523207879198678	    4.7540217508751841	    5.5856447764821437	    6.4096202174133348	;
   0.13603693565724398	   0.37679887511896587	   0.61963354213312805	   0.78923562313299123	   0.97786697384602994	    1.0954687695435457	    1.2579276190912578	    1.4718088779922600	    1.8996214793395854	    2.2665967947745673	    2.7921484061876254	    3.2642584288124792	    3.7497210083571413	    4.2366990139042953	    4.7553167799991867	    5.2281534880863783	    6.1530394507332673	    7.0706345048293295	;
   0.23009010366580107	   0.46925483792006439	   0.71797861715249633	   0.90135702833009901	    1.1117299283894952	    1.2446173463520698	    1.4258091019282138	    1.6623195765267931	    2.1214282118635079	    2.5323977817531276	    3.0969976176659300	    3.6375412632811548	    4.1793742215209164	    4.7377974108846717	    5.3295843539924990	    5.7995642937244671	    6.8640149326070965	    7.9474520002088918	;
   0.33037811069854761	   0.57147436703264765	   0.81675475892671967	   0.99764205729738309	    1.2101309648936283	    1.3449657728023658	    1.5326271307884514	    1.7807978166678664	    2.2610361913267343	    2.7003406676521555	    3.2919807517845090	    3.8491208606211607	    4.4310071412702134	    5.0355588811361214	    5.6722356343304341	    6.1706309682261162	    7.3185174878867274	    8.4980436336106262	;
   0.45415546374504473	   0.70568013570099497	   0.95382727219190533	    1.1251070113136168	    1.3277005354802358	    1.4555779109508755	    1.6364038397927347	    1.8878636585886228	    2.4037204569390935	    2.8777236707993850	    3.4993790453241145	    4.0811010764757683	    4.6988796183253907	    5.3409007699049225	    6.0299416408576363	    6.5698147754737022	    7.8069355959510158	    9.0754191304897720	;
   0.57940845481238212	   0.84234000880536686	    1.1136776179294348	    1.2924666340439068	    1.4521527649138426	    1.5620848947555632	    1.7312196427133164	    1.9933450777245745	    2.5172825204023752	    3.0393854565543861	    3.6911578259834434	    4.3136428930409032	    4.9618186740393231	    5.6311532721147284	    6.3781701871855914	    6.9619030365424122	    8.2818769573028455	    9.6199106218004626	;
   0.72791284341419282	   0.98796607577739415	    1.2323771139476327	    1.3857787854295196	    1.5575814288720502	    1.6774373363756345	    1.8530510686137989	    2.1262361871478159	    2.6765722379913792	    3.1988424897727223	    3.9319285970306965	    4.5937458692136737	    5.2637609733761881	    5.9921408359292689	    6.8035595127955046	    7.4368988445983133	    8.8425399533377185	    10.241071906527393	;
   0.93348421777998658	    1.2113541330632123	    1.4808434653447444	    1.6591595063442859	    1.8471332777006333	    1.9693685428031862	    2.1459397100082804	    2.3862511879441688	    2.9501105430385266	    3.5068733091098410	    4.2989194849900780	    4.9925277125770444	    5.6924297485372719	    6.5992135353025478	    7.5493083427841166	    8.2582353788796166	    9.7474874064540700	    11.190850080282528	;
    1.1114338823727437	    1.4606388882383117	    1.8140251580043434	    2.0614292475284635	    2.3310327085570886	    2.4929450635753541	    2.7091049141624080	    2.9875333561816499	    3.4821420106997185	    4.0376015150443889	    4.7004084654886347	    5.5141939308682666	    6.3827809003420324	    7.3693897728148618	    8.3694525016025612	    9.0997598320525448	    10.600406094839673	    12.060673055731430	;
    1.2526494159088677	    1.6586992473488098	    2.0708450033634334	    2.3636049677413320	    2.6936553924481204	    2.9030253239797768	    3.1966990632165770	    3.5796308816800737	    4.0685205202352259	    4.5889727030357150	    5.2642001359492125	    6.0495650398219993	    6.9399305450079636	    7.9152415431884480	    8.9366964088100183	    9.6591488693775052	    11.160378462767179	    12.644535681741386	;
    1.4718295539887079	    1.9525072511133248	    2.4396819963973200	    2.7799971872119431	    3.1492771241721331	    3.3695624795953592	    3.6598243887828743	    4.0012669700404322	    4.5095277912456897	    5.1291702811585322	    6.0223902217451393	    6.8150867278876435	    7.6456333696853358	    8.5389040985784721	    9.5848180728023973	    10.311777205296432	    11.849859006916125	    13.393987686140733	;
    1.7689675811327503	    2.3056187846886558	    2.8406670826550742	    3.2036552839738013	    3.5878670649719093	    3.8146988932616663	    4.1141199306089034	    4.4793458861634630	    5.1235525912177913	    5.7621210584844782	    6.6489851934062063	    7.3833184454044440	    8.1648355409700972	    9.0490315260335841	    10.085533414918656	    10.871613920953168	    12.543430383608438	    14.208327501486536	;
    2.0917161412128746	    2.6593713235123455	    3.2220894774786162	    3.6034333674217498	    4.0098831744694747	    4.2530828705010988	    4.5784460549513346	    4.9844510123708758	    5.7188145353833875	    6.3797365094910514	    7.2321336850029141	    7.9582225856337168	    8.7488240170282001	    9.6346679890011160	    10.616076900153958	    11.395457984316902	    13.188353954219414	    15.011517172971606	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 26864');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     60.737457969402662	;     60.737457969402662		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
